# License Management System

A PHP-based license management system that allows you to restrict script installation to one domain per license. This system includes an admin panel for managing licenses and a client-side verification script.

## Features

- One domain per license restriction
- Admin panel for license management
- License expiration support
- Domain verification
- License status tracking
- Responsive Bootstrap UI
- Client-side verification with caching

## Requirements

- PHP 7.4 or higher
- MySQL 5.7 or higher
- Apache/Nginx web server
- mod_rewrite enabled (for Apache)

## Installation

1. Clone or download this repository to your web server
2. Create a MySQL database and import the `database.sql` file
3. Configure your database connection in `config.php`
4. Set up your web server to point to the project directory
5. Access the admin panel at `http://your-domain.com/admin/`

Default admin credentials:
- Username: admin
- Password: admin123

**Important**: Change the default admin password after first login!

## Usage

### Admin Panel

1. Log in to the admin panel
2. Create new licenses by specifying the domain and optional expiration date
3. Manage existing licenses (activate/deactivate/delete)
4. View license verification logs

### Client Integration

To integrate the license verification in your application:

1. Copy the `client/verify_license.php` file to your application
2. Include and use the LicenseVerifier class:

```php
require_once 'verify_license.php';

$verifier = new LicenseVerifier(
    'YOUR-LICENSE-KEY',
    $_SERVER['HTTP_HOST'],
    'http://your-license-server.com/verify.php'
);

if (!$verifier->verify()) {
    die('Invalid license or domain. Please contact support.');
}
```

## Security Features

- Password hashing
- SQL injection prevention
- XSS protection
- License key validation
- Domain verification
- Verification caching
- Session management

## Directory Structure

```
├── admin/
│   ├── index.php
│   ├── login.php
│   └── logout.php
├── client/
│   └── verify_license.php
├── config.php
├── database.sql
├── verify.php
└── README.md
```

## License

This project is licensed under the MIT License - see the LICENSE file for details. 