<?php
// Database configuration
$host = 'localhost';
$user = 'root';
$pass = '';
$dbname = 'license_system';

try {
    // Create connection without database
    $pdo = new PDO("mysql:host=$host", $user, $pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    // Create database if not exists
    $pdo->exec("CREATE DATABASE IF NOT EXISTS `$dbname`");
    $pdo->exec("USE `$dbname`");
    
    // Drop existing tables
    $pdo->exec("DROP TABLE IF EXISTS license_logs");
    $pdo->exec("DROP TABLE IF EXISTS licenses");
    $pdo->exec("DROP TABLE IF EXISTS admin_users");
    
    // Create admin_users table
    $pdo->exec("CREATE TABLE admin_users (
        id INT AUTO_INCREMENT PRIMARY KEY,
        username VARCHAR(50) NOT NULL UNIQUE,
        password VARCHAR(255) NOT NULL,
        email VARCHAR(100) NOT NULL UNIQUE,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    )");
    
    // Create licenses table
    $pdo->exec("CREATE TABLE licenses (
        id INT AUTO_INCREMENT PRIMARY KEY,
        license_key VARCHAR(255) NOT NULL UNIQUE,
        domain VARCHAR(255) NOT NULL,
        status ENUM('active', 'inactive', 'expired') DEFAULT 'active',
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        expires_at TIMESTAMP NULL,
        last_check TIMESTAMP NULL
    )");
    
    // Create license_logs table
    $pdo->exec("CREATE TABLE license_logs (
        id INT AUTO_INCREMENT PRIMARY KEY,
        license_id INT,
        action VARCHAR(50) NOT NULL,
        ip_address VARCHAR(45),
        user_agent TEXT,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        FOREIGN KEY (license_id) REFERENCES licenses(id)
    )");
    
    // Insert default admin user
    $password = password_hash('admin123', PASSWORD_DEFAULT);
    $stmt = $pdo->prepare("INSERT INTO admin_users (username, password, email) VALUES (?, ?, ?)");
    $stmt->execute(['admin', $password, 'admin@example.com']);
    
    echo "Installation completed successfully!<br>";
    echo "You can now login with:<br>";
    echo "Username: admin<br>";
    echo "Password: admin123<br>";
    echo "<a href='admin/login.php'>Go to Login Page</a>";
    
} catch(PDOException $e) {
    die("Installation failed: " . $e->getMessage());
}
?> 